@REM @file
@REM
@REM @copyright
@REM  INTEL CONFIDENTIAL
@REM  Copyright 2010 - 2017 Intel Corporation.
@REM
@REM  The source code contained or described herein and all documents related to the
@REM  source code ("Material") are owned by Intel Corporation or its suppliers or
@REM  licensors. Title to the Material remains with Intel Corporation or its suppliers
@REM  and licensors. The Material may contain trade secrets and proprietary and
@REM  confidential information of Intel Corporation and its suppliers and licensors,
@REM  and is protected by worldwide copyright and trade secret laws and treaty
@REM  provisions. No part of the Material may be used, copied, reproduced, modified,
@REM  published, uploaded, posted, transmitted, distributed, or disclosed in any way
@REM  without Intel's prior express written permission.
@REM
@REM  No license under any patent, copyright, trade secret or other intellectual
@REM  property right is granted to or conferred upon you by disclosure or delivery
@REM  of the Materials, either expressly, by implication, inducement, estoppel or
@REM  otherwise. Any license under such intellectual property rights must be
@REM  express and approved by Intel in writing.
@REM
@REM  Unless otherwise agreed by Intel in writing, you may not remove or alter
@REM  this notice or any other notice embedded in Materials by Intel or
@REM  Intel's suppliers or licensors in any way.
@REM
@REM  This file contains a 'Sample Driver' and is licensed as such under the terms
@REM  of your license agreement with Intel or your vendor. This file may be modified
@REM  by the user, subject to the additional terms of the license agreement.
@REM
@REM @par Specification Reference:
@REM

@REM #
@REM #  Module Name:
@REM #
@REM #    postbuild.bat
@REM #
@REM #  Abstract:
@REM #
@REM #    Post build script.
@REM #
@REM #--*/

@set SCRIPT_ERROR=0

@if /I not "%0" == "%WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\postbuild.bat" (
  if /I not "%0" == "%WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\postbuild" (
    echo.
    echo !!! ERROR !!! This postbuild.bat must run under workspace root using "%WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\postbuild.bat" !!!
    echo.
    set SCRIPT_ERROR=1
    goto :EOF
  )
)

@REM ---run TXT ApFix up tool to patch ApInit module when TXT is enabled---
@findstr D1E59F50-E8C3-4545-BF61-11F002233C97 %BUILD_DIR_PATH%\FV\FVRECOVERY.inf > NUL
@if %ERRORLEVEL% NEQ 0 goto SkipStaFixUp
%WORKSPACE_CORE%\%CLIENT_COMMON_PACKAGE%\Tools\Stafixup\Stafixup.exe D1E59F50-E8C3-4545-BF61-11F002233C97 %BUILD_DIR_PATH%\FV\ClientBios.fd %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Apfixup.txt 0x20018
@if %ERRORLEVEL% NEQ 0 (
  set SCRIPT_ERROR=1
  goto :EOF
)
:SkipStaFixUp


@REM ---run FCE tool to write default setup variable to FD image---
move %BUILD_DIR_PATH%\FV\ClientBios.fd %BUILD_DIR_PATH%\FV\ClientBios.NoSetup.fd
copy /y /b %BUILD_DIR_PATH%\FV\SETUP_DATA.fv + %BUILD_DIR_PATH%\FV\ClientBios.NoSetup.fd %BUILD_DIR_PATH%\FV\CLIENT_SETUP.NoSetup.fd
@rem UQI 0006 005C 0078 0030 0034 0039 0046 is for PlatId question prompt (STR_PLATID_PROMPT) UQI string value.
@rem First 0006 is the length of string; Next six byte values are mapped to STR_PLATID_PROMPT string value (\x049F) defined in %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Setup\UqiList.uni.
set FCE_PATH=%PLATFORM_PACKAGE%
@REM
@REM AdvancedFeaturesBegin
@REM
set FCE_PATH=%BP_COMMON_PACKAGE%
@REM
@REM AdvancedFeaturesEnd
@REM
%WORKSPACE_CORE%\%FCE_PATH%\Tools\FCE\FCE.exe read -i %BUILD_DIR_PATH%\FV\CLIENT_SETUP.NoSetup.fd 0006 005C 0078 0030 0034 0039 0046 > %BUILD_DIR_PATH%\FV\ClientBios.fd.config
@if %ERRORLEVEL% NEQ 0 (
  set SCRIPT_ERROR=1
  goto :EOF
)
@rem %WORKSPACE_CORE%\%BP_COMMON_PACKAGE%\InternalOnly\Tools\FCE\FCE.exe update -i %BUILD_DIR_PATH%\FV\CLIENT_SETUP.NoSetup.fd -s %BUILD_DIR_PATH%\FV\ClientBios.fd.config -o %BUILD_DIR_PATH%\FV\CLIENT_SETUP.fd
%WORKSPACE_CORE%\%FCE_PATH%\Tools\FCE\FCE.exe update -i %BUILD_DIR_PATH%\FV\CLIENT_SETUP.NoSetup.fd -s %BUILD_DIR_PATH%\FV\ClientBios.fd.config -o %BUILD_DIR_PATH%\FV\CLIENT_SETUP.fd -g BA34AA5B-110E-4B10-B729-E559EFD075D3 -a

@if %ERRORLEVEL% NEQ 0 (
  set SCRIPT_ERROR=1
  goto :EOF
)
split -f %BUILD_DIR_PATH%\FV\CLIENT_SETUP.fd -s 0x100000
@if %ERRORLEVEL% NEQ 0 (
  set SCRIPT_ERROR=1
  goto :EOF
)
move /y %BUILD_DIR_PATH%\FV\CLIENT_SETUP.fd2 %BUILD_DIR_PATH%\FV\ClientBios_POST.fd
del %BUILD_DIR_PATH%\FV\CLIENT_SETUP.fd1
del %BUILD_DIR_PATH%\FV\CLIENT_SETUP.fd
del %BUILD_DIR_PATH%\FV\CLIENT_SETUP.NoSetup.fd
del %BUILD_DIR_PATH%\FV\ClientBios.NoSetup.fd
copy /y /b %BUILD_DIR_PATH%\FV\ClientBios_POST.fd %BUILD_DIR_PATH%\FV\ClientBios.fd
@if %FSP_WRAPPER_BUILD% EQU TRUE (
  if not exist %ROM_IMAGES_DIR_PATH% mkdir %ROM_IMAGES_DIR_PATH%
  copy /y /b %BUILD_DIR_PATH%\FV\ClientBios.fd %ROM_IMAGES_DIR_PATH%\KABYLAKEFSPWRAPPER.fd
)


@REM
@REM AdvancedFeaturesBegin
@REM
@echo.
@echo --- Analyze ASL runtime behavior using acpiexec ---
cd %BUILD_X64%
if not exist AslAnalyze\NUL mkdir AslAnalyze
if not exist AslAnalyze\Rvp3\NUL mkdir AslAnalyze\Rvp3
if not exist AslAnalyze\Rvp7\NUL mkdir AslAnalyze\Rvp7
if not exist AslAnalyze\Rvp8\NUL mkdir AslAnalyze\Rvp8
if not exist AslAnalyze\Rvp10\NUL mkdir AslAnalyze\Rvp10
if not exist AslAnalyze\Rvp11\NUL mkdir AslAnalyze\Rvp11
if not exist AslAnalyze\Rvp16\NUL mkdir AslAnalyze\Rvp16
if not exist AslAnalyze\SdlBrk\NUL mkdir AslAnalyze\SdlBrk
if not exist AslAnalyze\Sds\NUL mkdir AslAnalyze\Sds

@cd AslAnalyze
for /R ..\. %%I in (*.aml) do @copy /y /b %%I
@cd Rvp3
@move /y ..\*Rvp3*.aml
@move /y ..\Dptf.aml
@cd ../Rvp7
@move /y ..\*Rvp7*.aml
@cd ../Rvp8
@move /y ..\*Rvp8*.aml
@cd ../Rvp10
@move /y ..\*Rvp10*.aml
@cd ../Rvp11
@move /y ..\*Rvp11*.aml
@cd ../Rvp16
@move /y ..\*Rvp16*.aml
@cd ../SdlBrk
@move /y ..\*SdlBrk*.aml
@cd ../Sds
@move /y ..\*Sds*.aml
@cd ..

echo q | %ASL_TOOLS_DIR%\acpiexec -di -l *.aml Rvp3/*.aml > %BUILD_DIR_PATH%\AslAnalyzeRvp3.log
echo q | %ASL_TOOLS_DIR%\acpiexec -di -l *.aml Rvp7/*.aml > %BUILD_DIR_PATH%\AslAnalyzeRvp7.log
echo q | %ASL_TOOLS_DIR%\acpiexec -di -l *.aml Rvp8/*.aml > %BUILD_DIR_PATH%\AslAnalyzeRvp8.log
echo q | %ASL_TOOLS_DIR%\acpiexec -di -l *.aml Rvp10/*.aml > %BUILD_DIR_PATH%\AslAnalyzeRvp10.log
echo q | %ASL_TOOLS_DIR%\acpiexec -di -l *.aml Rvp11/*.aml > %BUILD_DIR_PATH%\AslAnalyzeRvp11.log
echo q | %ASL_TOOLS_DIR%\acpiexec -di -l *.aml Rvp16/*.aml > %BUILD_DIR_PATH%\AslAnalyzeRvp16.log
echo q | %ASL_TOOLS_DIR%\acpiexec -di -l *.aml SdlBrk/*.aml > %BUILD_DIR_PATH%\AslAnalyzeSdlBrk.log
echo q | %ASL_TOOLS_DIR%\acpiexec -di -l *.aml Sds/*.aml > %BUILD_DIR_PATH%\AslAnalyzeSds.log

@echo --- ASL analysis completed ---
@echo.
@REM
@REM AdvancedFeaturesEnd
@REM
@cd %WORKSPACE_PLATFORM%



@REM
@REM AdvancedFeaturesBegin
@REM
    @REM ---run TXTSX tool to generate FIT table---
    if exist %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\ToolScripts\FitGen\postbuildFitGen.bat (
      call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\ToolScripts\FitGen\postbuildFitGen.bat
      if %SCRIPT_ERROR% NEQ 0 goto :EOF
    )

    if exist %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\ToolScripts\BpmGen\postbuildBpmGen.bat (
      call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\ToolScripts\BpmGen\postbuildBpmGen.bat ClientBios_FIT ClientBios
      if %SCRIPT_ERROR% NEQ 0 goto :EOF
    )
@REM
@REM AdvancedFeaturesEnd
@REM


@rem create RecoveryFvMain image (FVMAIN_COMPACT_RECOVERY.Fv) with emulation variable driver
@cd %BUILD_DIR_PATH%\FV
copy /y /b FVMAIN_COMPACT.Fv FVMAIN_COMPACT_RECOVERY.Fv
@REM
@REM AdvancedFeaturesBegin
@REM
%WORKSPACE_CORE%\%BP_COMMON_PACKAGE%\Tools\FMMT\FMMT.exe -d FVMAIN_COMPACT_RECOVERY.Fv FV1 VariableSmmRuntimeDxe FVMAIN_COMPACT_RECOVERY.Fv > NUL
%WORKSPACE_CORE%\%BP_COMMON_PACKAGE%\Tools\FMMT\FMMT.exe -d FVMAIN_COMPACT_RECOVERY.Fv FV1 VariableSmm FVMAIN_COMPACT_RECOVERY.Fv > NUL
%WORKSPACE_CORE%\%BP_COMMON_PACKAGE%\Tools\FMMT\FMMT.exe -a FVMAIN_COMPACT_RECOVERY.Fv FV1 Ffs\02B01AD5-7E59-43e8-A6D8-238180613A5AEmuVariableRuntimeDxe\02B01AD5-7E59-43e8-A6D8-238180613A5A.ffs FVMAIN_COMPACT_RECOVERY.Fv
@REM
@REM AdvancedFeaturesEnd
@REM
@cd %WORKSPACE%

@rem Create directory for the secure boot by default intermediate files
@if not exist %BUILD_DIR%\FV\SecureBootEnabled\ @mkdir %BUILD_DIR%\FV\SecureBootEnabled\
@copy /y %BUILD_DIR%\FV\ClientBios.fd %BUILD_DIR%\FV\SecureBootEnabled\

@echo Create using Production  keys
@if exist %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\InternalOnly\ToolScripts\KeyEnroll\MsEnrollRestricted.bat call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\InternalOnly\ToolScripts\KeyEnroll\MsEnrollRestricted.bat %BUILD_DIR_PATH%\

@REM ---run Fitc and create ROM images---
@if exist %BUILD_DIR_PATH%\X64\%PLATFORM_SI_PACKAGE%\Pch (
    call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\SetupRomDirs.bat
    @REM BUILD_ROM_ONLY
    @if "%1" == "rom" (
        goto :EOF
    )


    if exist %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\KabylakeLP\SunrisepointCx\BuildRom.bat (
      call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\KabylakeLP\SunrisepointCx\BuildRom.bat %BUILD_DIR_PATH% KabylakeLp\SunrisepointCx
      if errorlevel 1 (
        set SCRIPT_ERROR=1
        goto :EOF
      )
    )

    if exist %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\KabylakeLP_SV_FW\SunrisepointCx\BuildRom.bat (
      call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\KabylakeLP_SV_FW\SunrisepointCx\BuildRom.bat %BUILD_DIR_PATH% KabylakeLp_SV_FW\SunrisepointCx
      if errorlevel 1 (
        set SCRIPT_ERROR=1
        goto :EOF
      )
    )

    if exist %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\KabylakeH\KabylakePchAx\BuildRom.bat (
      call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\KabylakeH\KabylakePchAx\BuildRom.bat %BUILD_DIR_PATH% KabylakeH\KabylakePchAx
      if errorlevel 1 (
        set SCRIPT_ERROR=1
        goto :EOF
      )
    )

    if exist %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\SkylakeH\SunrisepointDx\BuildRom.bat (
      call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\SkylakeH\SunrisepointDx\BuildRom.bat %BUILD_DIR_PATH% SkylakeH\SunrisepointDx
      if errorlevel 1 (
        set SCRIPT_ERROR=1
        goto :EOF
      )
    )
    if exist %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\KabylakeH_SV_FW\KabylakePchAx\BuildRom.bat (
      call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\KabylakeH_SV_FW\KabylakePchAx\BuildRom.bat %BUILD_DIR_PATH% KabylakeH_SV_FW\KabylakePchAx
      if errorlevel 1 (
        set SCRIPT_ERROR=1
        goto :EOF
      )
    )
    if exist %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\SkylakeH_SV_FW\SunrisepointDx\BuildRom.bat (
      call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\RomImage\SkylakeH_SV_FW\SunrisepointDx\BuildRom.bat %BUILD_DIR_PATH% SkylakeH_SV_FW\SunrisepointDx
      if errorlevel 1 (
        set SCRIPT_ERROR=1
        goto :EOF
      )
    )
  )
@if %FSP_WRAPPER_BUILD% EQU TRUE (
  del /f %WORKSPACE_SILICON%\KabylakeFspBinPkg\Fsp_Rebased*.fd
)

@if %FSP_WRAPPER_BUILD% EQU TRUE exit /b

